//
//  v002FBOGLSLTemplatePlugIn.m
//  v002FBOGLSLTemplate
//
//  Created by vade on 6/30/08.
//  Copyright (c) 2008 __MyCompanyName__. All rights reserved.
//

/* It's highly recommended to use CGL macros instead of changing the current context for plug-ins that perform OpenGL rendering */
#import <OpenGL/CGLMacro.h>

#import "v002_DilatePlugIn.h"

#define	kQCPlugIn_Name				@"v002 Dilate"
#define	kQCPlugIn_Description		@"Dilate Image - basic morphological set transformations"


#pragma mark -
#pragma mark Static Functions


//- (GLint) getUniformLocation:(GLhandleARB)theProgramObject uniformName:(const GLcharARB *)theUniformName
static GLintptr getUniformLocation(GLhandleARB theProgramObject,  const GLcharARB *theUniformName) 
{
	
	// for GLMacros
	CGLContextObj cgl_ctx = CGLGetCurrentContext();
	
	GLint uniformLoacation = glGetUniformLocationARB(theProgramObject, theUniformName);
	
	if (uniformLoacation == -1) 
	{
		//	NSLog( @">> WARNING: No such uniform named \"%s\"\n", theUniformName );
	} // if
	
	return uniformLoacation;
} // getUniformLocation



static GLhandleARB LoadShader(GLenum theShaderType, const GLcharARB **theShader, GLint *theShaderCompiled, CGLContextObj currentCGLContext) 
{	
	CGLContextObj cgl_ctx = CGLGetCurrentContext();
	
	//	NSLog(@"Static LoadShader set current GLContext");
	
	GLhandleARB shaderObject = NULL;
	
	if (theShader != NULL) 
	{
		GLint infoLogLength = 0;
		
		shaderObject = glCreateShaderObjectARB(theShaderType);
		//		NSLog(@"Static LoadShader created ShaderObject");
		
		glShaderSourceARB(shaderObject, 1, theShader, NULL);
		glCompileShaderARB(shaderObject);
		
		glGetObjectParameterivARB(shaderObject, GL_OBJECT_INFO_LOG_LENGTH_ARB, &infoLogLength);
		
		if (infoLogLength > 0) 
		{
			GLcharARB *infoLog = (GLcharARB *)malloc(infoLogLength);
			
			if (infoLog != NULL)
			{
				glGetInfoLogARB(shaderObject, infoLogLength, &infoLogLength, infoLog);
				
				//		NSLog(@">> Shader compile log:\n%s\n", infoLog);
				
				free(infoLog);
			} // if
		} // if
		
		glGetObjectParameterivARB(shaderObject, GL_OBJECT_COMPILE_STATUS_ARB, theShaderCompiled);
		
		if (*theShaderCompiled == 0)
		{
			//	NSLog(@">> Failed to compile shader %s\n", theShader);
		} // if
	} // if
	else 
	{
		*theShaderCompiled = 1;
	} // else
	
	return shaderObject;
} // LoadShader

//------------------------------------------------------------------------

//static void LinkProgram(GLhandleARB programObject, GLint *theProgramLinked, id<QCPlugInContext> pluginContext ) 
static void LinkProgram(GLhandleARB programObject, GLint *theProgramLinked, CGLContextObj currentCGLContext) 
{
	CGLContextObj cgl_ctx = CGLGetCurrentContext();
	
	
	GLint  infoLogLength = 0;
	
	glLinkProgramARB(programObject);
	
	glGetObjectParameterivARB(programObject , GL_OBJECT_INFO_LOG_LENGTH_ARB, &infoLogLength);
	
	if (infoLogLength >  0) 
	{
		GLcharARB *infoLog = (GLcharARB *)malloc(infoLogLength);
		
		if (infoLog != NULL)
		{
			glGetInfoLogARB(programObject, infoLogLength, &infoLogLength, infoLog);
			
			//	NSLog(@">> Program link log:\n%s\n", infoLog);
			
			free(infoLog);
		} // if
	} // if
	
	glGetObjectParameterivARB(programObject, GL_OBJECT_LINK_STATUS_ARB, theProgramLinked);
	
	if (*theProgramLinked == 0)
	{
		//	NSLog(@">> Failed to link program %d\n", (int)programObject);
	} // if
} // LinkProgram


static void _TextureReleaseCallback(CGLContextObj cgl_ctx, GLuint name, void* info)
{
	glDeleteTextures(1, &name);
}

/* Generates a texture containing a linear gradient - Requires FBO support */
static GLuint renderToFBO(CGLContextObj cgl_ctx, NSUInteger pixelsWide, NSUInteger pixelsHigh, NSRect bounds, GLuint videoTexture, GLhandleARB program, GLfloat amount)
{
	//	CGLContextObj cgl_ctx = [context CGLContextObj];
	CGLSetCurrentContext(cgl_ctx);
	CGLLockContext(cgl_ctx);
	
	GLsizei							width = bounds.size.width,	height = bounds.size.height;
	GLuint							name,frameBuffer;
	GLint							saveName, saveViewport[4], saveMode;
	GLenum							status;
	
	// Create texture to render into 
	glGenTextures(1, &name);
	glGetIntegerv(GL_TEXTURE_BINDING_RECTANGLE_EXT, &saveName);
	glBindTexture(GL_TEXTURE_RECTANGLE_EXT, name);
	//	glTexImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, GL_RGBA8, width, height, 0, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, NULL);
	glTexImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, GL_RGBA8, width, height, 0, GL_BGRA, GL_UNSIGNED_BYTE, NULL); 
	
	// Create temporary FBO to render in texture 
	glGenFramebuffersEXT(1, &frameBuffer);
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, frameBuffer);
	glFramebufferTexture2DEXT(GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_RECTANGLE_EXT, name, 0);
	
	// Assume FBOs JUST WORK, because we checked on startExecution	
	//	status = glCheckFramebufferStatusEXT(GL_FRAMEBUFFER_EXT);	
	//	if(status == GL_FRAMEBUFFER_COMPLETE_EXT)
	{	
		
		// Setup OpenGL states 
		glGetIntegerv(GL_VIEWPORT, saveViewport);
		glViewport(0, 0, width, height);
		glGetIntegerv(GL_MATRIX_MODE, &saveMode);
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();
		glOrtho(bounds.origin.x, bounds.origin.x + bounds.size.width, bounds.origin.y, bounds.origin.y + bounds.size.height, -1, 1);
		
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		
		// bind video texture
		glClearColor(0.0, 0.0, 0.0, 0.0);
		glClear(GL_COLOR_BUFFER_BIT);		
		
		// draw our input video
		glEnable(GL_TEXTURE_RECTANGLE_EXT);
		glBindTexture(GL_TEXTURE_RECTANGLE_EXT, videoTexture);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		
		
		// bind our shader program
		glUseProgramObjectARB(program);
		
		// set program vars
		glUniform1iARB(getUniformLocation(program, "tex0"), 0); // load tex1 sampler to texture unit 0 
		glUniform1fARB(getUniformLocation(program, "amount"), amount); // load tex1 sampler to texture unit 0 
		
		
		glBegin(GL_QUADS);
		glTexCoord2f(0, 0);
		glVertex2f(0, 0);
		glTexCoord2f(0, pixelsHigh);
		glVertex2f(0, height);
		glTexCoord2f(pixelsWide, pixelsHigh);
		glVertex2f(width, height);
		glTexCoord2f(pixelsWide, 0);
		glVertex2f(width, 0);
		glEnd();		
		
		// disable shader program
		glUseProgramObjectARB(NULL);
		
		// Restore OpenGL states 
		glMatrixMode(GL_MODELVIEW);
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(saveMode);
		glViewport(saveViewport[0], saveViewport[1], saveViewport[2], saveViewport[3]);		
	}
	
	/*	else
	 {
	 glDeleteTextures(1, &name);
	 name = 0;
	 }
	 */
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0);
	glDeleteFramebuffersEXT(1, &frameBuffer);
	
	// Check for OpenGL errors 
	status = glGetError();
	if(status)
	{
		NSLog(@"OpenGL error %04X", status);
		glDeleteTextures(1, &name);
		name = 0;
	}
	
	CGLUnlockContext(cgl_ctx);
	
	return name;
}

@implementation v002_DilatePlugIn

/*
 Here you need to declare the input / output properties as dynamic as Quartz Composer will handle their implementation
 @dynamic inputFoo, outputBar;
 */

@dynamic inputImage, inputAmount, outputImage;

+ (NSDictionary*) attributes
{
	/*
	 Return a dictionary of attributes describing the plug-in (QCPlugInAttributeNameKey, QCPlugInAttributeDescriptionKey...).
	 */
	
	return [NSDictionary dictionaryWithObjectsAndKeys:kQCPlugIn_Name, QCPlugInAttributeNameKey, kQCPlugIn_Description, QCPlugInAttributeDescriptionKey, nil];
}

+ (NSDictionary*) attributesForPropertyPortWithKey:(NSString*)key
{
	if([key isEqualToString:@"inputImage"])
	{
		return [NSDictionary dictionaryWithObjectsAndKeys:@"Image", QCPortAttributeNameKey, nil];
	}
	
	if([key isEqualToString:@"inputAmount"])
	{
		return [NSDictionary dictionaryWithObjectsAndKeys:@"Amount", QCPortAttributeNameKey,
				[NSNumber numberWithFloat:0.0], QCPortAttributeMinimumValueKey,
				[NSNumber numberWithFloat:0.0], QCPortAttributeDefaultValueKey,
				nil];
	}
	
	if([key isEqualToString:@"outputImage"])
	{
		return [NSDictionary dictionaryWithObjectsAndKeys:@"Image", QCPortAttributeNameKey, nil];
	}
	return nil;
}

+ (NSArray*) sortedPropertyPortKeys
{
	return [NSArray arrayWithObjects:@"inputImage", @"inputAmount", nil];
}

+ (QCPlugInExecutionMode) executionMode
{
	/*
	 Return the execution mode of the plug-in: kQCPlugInExecutionModeProvider, kQCPlugInExecutionModeProcessor, or kQCPlugInExecutionModeConsumer.
	 */
	
	return kQCPlugInExecutionModeProcessor;
}

+ (QCPlugInTimeMode) timeMode
{
	/*
	 Return the time dependency mode of the plug-in: kQCPlugInTimeModeNone, kQCPlugInTimeModeIdle or kQCPlugInTimeModeTimeBase.
	 */
	
	return kQCPlugInTimeModeNone;
}

- (id) init
{
	if(self = [super init]) {
		/*
		 Allocate any permanent resource required by the plug-in.
		 */
	}
	
	return self;
}

- (void) finalize
{
	/*
	 Release any non garbage collected resources created in -init.
	 */
	
	[super finalize];
}

- (void) dealloc
{
	/*
	 Release any resources created in -init.
	 */
	[super dealloc];
}

@end

@implementation v002_DilatePlugIn (Execution)

- (BOOL) startExecution:(id<QCPlugInContext>)context
{
	// work around lack of GLMacro.h for now
	CGLContextObj cgl_ctx = [context CGLContextObj];
	CGLSetCurrentContext(cgl_ctx);
	// shaders
	if(![self loadShadersFromResource:@"v002.dilate"])
	{
		NSLog(@"Cannot compile GLSL shader ");
		return NO;
	}
	
	// build up and destroy an FBO. If it works, we are good to go and dont do any other slow error checking for our main rendering, 
	// if we cant make the FBO, fail by returning NO.
	GLuint name,frameBuffer;
	GLenum status;
	
	glGenTextures(1, &name);
	glBindTexture(GL_TEXTURE_RECTANGLE_EXT, name);
	glTexImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, GL_RGBA8, 640, 480, 0, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, NULL);
	
	// Create temporary FBO to render in texture 
	glGenFramebuffersEXT(1, &frameBuffer);
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, frameBuffer);
	glFramebufferTexture2DEXT(GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_RECTANGLE_EXT, name, 0);
	
	status = glCheckFramebufferStatusEXT(GL_FRAMEBUFFER_EXT);
	
	if(status != GL_FRAMEBUFFER_COMPLETE_EXT)
	{	
		NSLog(@"Cannot create FBO");
		glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0);
		glDeleteFramebuffersEXT(1, &frameBuffer);
		glDeleteTextures(1, &name);
		
		return NO;
	}	
	
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0);
	glDeleteFramebuffersEXT(1, &frameBuffer);
	glDeleteTextures(1, &name);
	
	return YES;
	
}

- (BOOL) execute:(id<QCPlugInContext>)context atTime:(NSTimeInterval)time withArguments:(NSDictionary*)arguments
{
	/*
	 Called by Quartz Composer whenever the plug-in instance needs to execute.
	 Only read from the plug-in inputs and produce a result (by writing to the plug-in outputs or rendering to the destination OpenGL context) within that method and nowhere else.
	 Return NO in case of failure during the execution (this will prevent rendering of the current frame to complete).
	 
	 The OpenGL context for rendering can be accessed and defined for CGL macros using:
	 CGLContextObj cgl_ctx = [context CGLContextObj];
	 */
	
	CGLContextObj cgl_ctx = [context CGLContextObj];
	CGLSetCurrentContext(cgl_ctx);
	
	id<QCPlugInInputImageSource>   image = self.inputImage;
	NSUInteger width = [image imageBounds].size.width;
	NSUInteger height = [image imageBounds].size.height;
	NSRect bounds = [image imageBounds];
	GLfloat amt = self.inputAmount;
	
	
	if(image && [image lockTextureRepresentationWithColorSpace:[image imageColorSpace] forBounds:[image imageBounds]])
	{	
		[image bindTextureRepresentationToCGLContext:[context CGLContextObj] textureUnit:GL_TEXTURE0 normalizeCoordinates:NO];
		GLuint finalOutput;
		
		// if the blur is suitably small, dont bother doing multipass. this produces a nonlinearity in the blur, but, its hard to notice
		
			// Make sure to flush as we use FBOs and the passed OpenGL context may not have a surface attached
			finalOutput = renderToFBO(cgl_ctx, width, height, bounds, [image textureName], glslProgramObject, amt);
			glFlushRenderAPPLE();
				
		if(finalOutput == 0)
			return NO;
		
		id provider;	
		
		// properly handle grey colorspaces. Need to determine how to handle float data, but for now, 8bit RGB or 8Bit grey.
		if(CGColorSpaceGetNumberOfComponents([image imageColorSpace]) > 1)			
			// output our final image as a QCPluginOutputImageProvider using the QCPluginContext convinience method. No need to go through the trouble of making our own conforming object.	
#if __BIG_ENDIAN__
		provider = [context outputImageProviderFromTextureWithPixelFormat:QCPlugInPixelFormatARGB8 pixelsWide:[image imageBounds].size.width pixelsHigh:[image imageBounds].size.height name:finalOutput flipped:[image textureFlipped] releaseCallback:_TextureReleaseCallback releaseContext:NULL colorSpace:[image imageColorSpace] shouldColorMatch:YES];
#else
		provider = [context outputImageProviderFromTextureWithPixelFormat:QCPlugInPixelFormatBGRA8 pixelsWide:[image imageBounds].size.width pixelsHigh:[image imageBounds].size.height name:finalOutput flipped:[image textureFlipped] releaseCallback:_TextureReleaseCallback releaseContext:NULL colorSpace:[image imageColorSpace] shouldColorMatch:YES];
#endif
		else
			provider = [context outputImageProviderFromTextureWithPixelFormat:QCPlugInPixelFormatI8 pixelsWide:[image imageBounds].size.width pixelsHigh:[image imageBounds].size.height name:finalOutput flipped:[image textureFlipped] releaseCallback:_TextureReleaseCallback releaseContext:NULL colorSpace:[image imageColorSpace] shouldColorMatch:YES];				
		
		if(provider == nil)
			return NO;
		
		self.outputImage = provider;
		
		[image unbindTextureRepresentationFromCGLContext:[context CGLContextObj] textureUnit:GL_TEXTURE0];
		[image unlockTextureRepresentation];
	}	
	else
		self.outputImage = nil;
	
	return YES;
}

- (void) enableExecution:(id<QCPlugInContext>)context
{
}

- (void) disableExecution:(id<QCPlugInContext>)context
{
}

- (void) stopExecution:(id<QCPlugInContext>)context
{
	CGLContextObj cgl_ctx = [context CGLContextObj];
	// remove our GLSL program
	glDeleteObjectARB(glslProgramObject);
	glslProgramObject = NULL;	
}


#pragma mark -
#pragma mark GLSL compilation and loading code
// from GLSLBasics Cocoa

//------------------------------------------------------------------------

- (GLcharARB *) getShaderSourceFromResource:(NSString *)theShaderResourceName extension:(NSString *)theExtension
{
	
	NSBundle *appBundle=[NSBundle bundleForClass:[self class]];
	NSString  *shaderTempSource  = [appBundle pathForResource:theShaderResourceName ofType:theExtension];
	GLcharARB *shaderSource      = NULL;
	
	//	NSLog(@"assumed path is : %@", [appBundle bundlePath]);
	
	//	NSLog(@" Shader location is: %@", shaderTempSource);
	
	shaderTempSource = [NSString stringWithContentsOfFile:shaderTempSource];
	
	//	NSLog(@" Shader source is: %@", shaderTempSource);
	
	shaderSource = (GLcharARB *)[shaderTempSource cStringUsingEncoding:NSASCIIStringEncoding];
	
	return  shaderSource;
} // getShaderSourceFromResource

//------------------------------------------------------------------------

- (void) getFragmentShaderSourceFromResource:(NSString *)theFragmentShaderResourceName
{
	fragmentShaderSource = [self getShaderSourceFromResource:theFragmentShaderResourceName extension:@"frag" ];
} // getFragmentShaderSourceFromResource

//------------------------------------------------------------------------

- (void) getVertexShaderSourceFromResource:(NSString *)theVertexShaderResourceName
{
	vertexShaderSource = [self getShaderSourceFromResource:theVertexShaderResourceName extension:@"vert" ];
} // getVertexShaderSourceFromResource

//------------------------------------------------------------------------

- (BOOL) newProgramObject:(GLhandleARB)theVertexShader  fragmentShaderHandle:(GLhandleARB)theFragmentShader
{
	// set GL context
	//CGLContextObj cgl_ctx = [pluginContext CGLContextObj];
	CGLContextObj cgl_ctx = CGLGetCurrentContext();
	
	
	GLint programLinked = 0;
	
	// Create a program object and link both shaders
	
	glslProgramObject = glCreateProgramObjectARB();
	
	glAttachObjectARB(glslProgramObject, theVertexShader);
	glDeleteObjectARB(theVertexShader);   // Release
	
	glAttachObjectARB(glslProgramObject, theFragmentShader);
	glDeleteObjectARB(theFragmentShader); // Release
	
	LinkProgram(glslProgramObject, &programLinked, [pluginContext CGLContextObj]);
	//	LinkProgram(glslProgramObject, &programLinked);
	
	if (!programLinked) 
	{
		glDeleteObjectARB(glslProgramObject);
		
		glslProgramObject = NULL;
		
		return NO;
	} // if
	
	return YES;
} // newProgramObject

//------------------------------------------------------------------------

- (GLhandleARB) loadShader:(GLenum)theShaderType shaderSource:(const GLcharARB **)theShaderSource
{
	//	NSLog(@"Attempting to load shader");
	// set gl context for glMacro.h
	CGLContextObj cgl_ctx = [pluginContext CGLContextObj];
	
	//	NSLog(@"set the gl context");
	
	
	GLint       shaderCompiled = 0;
	//	GLhandleARB shaderHandle   = LoadShader(theShaderType, theShaderSource, &shaderCompiled, pluginContext);
	//	NSLog(@"passing to static LoadShader");
	
	GLhandleARB shaderHandle   = LoadShader(theShaderType, theShaderSource, &shaderCompiled,[pluginContext CGLContextObj]);
	
	
	if (!shaderCompiled) 
	{
		if (shaderHandle) 
		{
			glDeleteObjectARB(shaderHandle);
			shaderHandle = NULL;
		} // if
	} // if
	
	return shaderHandle;
} // loadShader

//------------------------------------------------------------------------
- (BOOL) setProgramObject
{
	BOOL  programObjectSet = NO;
	
	// Load and compile both shaders
	//	NSLog(@"attempting to load vertex shader");
	GLhandleARB vertexShader = [self loadShader:GL_VERTEX_SHADER_ARB shaderSource:&vertexShaderSource];
	
	// Ensure vertex shader compiled
	
	if (vertexShader != NULL)
	{
		//	NSLog(@"attempting to load fragment shader");
		GLhandleARB fragmentShader = [self loadShader:GL_FRAGMENT_SHADER_ARB shaderSource:&fragmentShaderSource];
		
		// Ensure fragment shader compiled
		
		if (fragmentShader != NULL) 
		{
			// Create a program object and link both shaders
			
			programObjectSet = [self newProgramObject:vertexShader fragmentShaderHandle:fragmentShader];
		} // if
	} // if
	
	return  programObjectSet;
} // setProgramObject

//------------------------------------------------------------------------

- (BOOL) loadShadersFromResource:(NSString *)theShadersName
{
	BOOL  loadedShaders = NO;
	
	// Load vertex and fragment shader
	
	[self getVertexShaderSourceFromResource:theShadersName];
	
	if (vertexShaderSource != NULL)
	{
		[self getFragmentShaderSourceFromResource:theShadersName];
		
		if (fragmentShaderSource != NULL)
		{
			loadedShaders = [self setProgramObject];
			
			if (!loadedShaders)
			{
				//	NSLog(@">> WARNING: Failed to load GLSL \"%@\" fragment & vertex shaders!\n", theShadersName);
			} // if
		} // if
	} // if
	
	return  loadedShaders;
} // loadShadersFromResource


@end
/*
 #pragma mark -
 #pragma mark  Image QCPlugInOutputImageProvider
 #pragma mark -
 
 @implementation v002BlurImageProvider
 
 - (id) initWithTexture:(GLuint)imageSource target:(GLenum) textureTarget width:(GLfloat)w height:(GLfloat)h program:(GLhandleARB) p amount:(double) a
 {	
 if(self = [super init])
 {
 image = imageSource;
 imageTarget = textureTarget;
 width = w;
 height = h;
 program = p;
 amount = [[NSNumber numberWithDouble:a] retain];
 return self;
 }
 return nil;
 }
 
 - (void) dealloc
 {	
 [amount release];
 
 [super dealloc];
 }
 
 
 - (GLuint) copyRenderedTextureForCGLContext:(CGLContextObj)cgl_ctx pixelFormat:(NSString*)format bounds:(NSRect)bounds isFlipped:(BOOL*)flipped
 {
 //	CGLLockContext(cgl_ctx);
 
 float amt = [amount floatValue];
 amt = fabs(amt);
 
 GLuint texture1 = renderToFBO(cgl_ctx, width, height, NSMakeRect(bounds.origin.x, bounds.origin.y, (int) ((float)bounds.size.width/(1 + amt * 2.5)), (int) ((float)bounds.size.height/(1 + amt * 2.5)) ), image, imageTarget, program, amt, NO);
 GLuint texture2 = renderToFBO(cgl_ctx, (int) ((float)width/(1 + amt * 2.5)), (int)((float)height/(1 + amt * 2.5 )), NSMakeRect(bounds.origin.x, bounds.origin.y,(int) ((float)bounds.size.width/(1 + amt * 2.0)), (int)((float)bounds.size.height/(1 + amt *2.0)) ), texture1, imageTarget, program, amt, NO);
 GLuint texture3 = renderToFBO(cgl_ctx, (int) ((float)width/(1 + amt * 2.0)), (int)((float)height/(1 + amt * 2.0 )), NSMakeRect(bounds.origin.x, bounds.origin.y,(int) ((float)bounds.size.width/(1 + amt * 1.5)), (int) ((float)bounds.size.height/(1 + amt *1.5)) ), texture2, imageTarget, program, amt, NO);
 GLuint texture4 = renderToFBO(cgl_ctx, (int) ((float)width/(1 + amt * 1.5)), (int)((float)height/(1 + amt * 1.5 )), NSMakeRect(bounds.origin.x, bounds.origin.y,(int) ((float)bounds.size.width/(1 + amt)), (int) ((float)bounds.size.height/(1 + amt)) ), texture3, imageTarget, program, amt, NO);
 GLuint texture5 = renderToFBO(cgl_ctx, (int) ((float)width/(1 + amt)), (int)((float)height/(1 + amt)), bounds, texture4, imageTarget, program, amt, flipped);
 
 glDeleteTextures(1, &texture1);
 glDeleteTextures(1, &texture2);
 glDeleteTextures(1, &texture3);
 glDeleteTextures(1, &texture4);
 
 //	CGLUnlockContext(cgl_ctx);
 
 return texture5;
 }
 
 - (void) releaseRenderedTexture:(GLuint)name forCGLContext:(CGLContextObj)context
 {
 CGLContextObj cgl_ctx = context;
 CGLSetCurrentContext(cgl_ctx);
 //	NSLog(@"Texture to delete is is : %u", name);
 glDeleteTextures(1, &name);
 }
 
 - (NSRect) imageBounds
 {
 return NSMakeRect(0.0, 0.0, width, height);
 }
 
 - (CGColorSpaceRef) imageColorSpace
 {
 return CGColorSpaceCreateWithName(kCGColorSpaceGenericRGB);
 }
 
 - (NSArray*) supportedRenderedTexturePixelFormats
 {
 //NSLog(@"called supportedRenderedTexturePixelFormats");
 #if __BIG_ENDIAN__
 return [NSArray arrayWithObjects:QCPlugInPixelFormatARGB8,nil];
 #else
 return [NSArray arrayWithObjects:QCPlugInPixelFormatBGRA8,nil];
 #endif
 }
 
 @end
 */